/*
 * Decompiled with CFR 0.152.
 */
package io.zhile.research.intellij.ier.common;

import com.intellij.openapi.util.io.FileUtil;
import io.zhile.research.intellij.ier.common.EvalRecord;
import io.zhile.research.intellij.ier.helper.DateTime;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Date;

public class LicenseFileRecord
implements EvalRecord {
    private final String type = "LICENSE";
    private final File file;
    private String expireDate;

    public LicenseFileRecord(File file) {
        this.file = file;
        try (DataInputStream dis = new DataInputStream(new FileInputStream(file));){
            this.expireDate = DateTime.DF_DATETIME.format(new Date((dis.readLong() ^ 0xFFFFFFFFFFFFFFFFL) + 2592000000L));
        }
        catch (Exception e) {
            this.expireDate = "ERROR";
        }
    }

    public static void touch(File file) throws Exception {
        try (DataOutputStream dos = new DataOutputStream(new FileOutputStream(file));){
            dos.writeLong(System.currentTimeMillis() ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    @Override
    public void reset() throws Exception {
        if (!FileUtil.delete((File)this.file)) {
            throw new Exception("Remove LICENSE failed: " + this.file.getAbsolutePath());
        }
        LicenseFileRecord.touch(this.file);
    }

    public String toString() {
        return "LICENSE: " + this.file.getName() + ", UNTIL: " + this.expireDate;
    }
}

