/*
 * Decompiled with CFR 0.152.
 */
package io.zhile.research.intellij.ier.common;

import com.intellij.ide.Prefs;
import io.zhile.research.intellij.ier.common.EvalRecord;
import io.zhile.research.intellij.ier.common.KeepCondition;
import io.zhile.research.intellij.ier.common.Resetter;
import java.util.prefs.Preferences;

public class PreferenceRecord
implements EvalRecord {
    private static final String DEFAULT_VALUE = null;
    private final String type = "PREFERENCE";
    private final String key;
    private final String value;
    private final boolean isRaw;
    private final KeepCondition keepCondition;

    public PreferenceRecord(String key) {
        this(key, false, null);
    }

    public PreferenceRecord(String key, boolean isRaw) {
        this(key, isRaw, null);
    }

    public PreferenceRecord(String key, boolean isRaw, KeepCondition keepCondition) {
        this.key = key;
        this.isRaw = isRaw;
        this.keepCondition = keepCondition;
        this.value = isRaw ? Preferences.userRoot().get(key, DEFAULT_VALUE) : Prefs.get((String)key, (String)DEFAULT_VALUE);
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public void reset() throws Exception {
        if (null != this.keepCondition && this.keepCondition.needKeep()) {
            return;
        }
        if (this.isRaw) {
            Preferences.userRoot().remove(this.key);
        } else {
            Prefs.remove((String)this.key);
        }
        Resetter.syncPrefs();
    }

    public String toString() {
        String v = null == this.value ? "" : this.value;
        return "PREFERENCE: " + this.key + " = " + v.substring(0, Math.min(36, v.length()));
    }
}

