/*
 * Decompiled with CFR 0.152.
 */
package io.zhile.research.intellij.ier.ui.form;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import io.zhile.research.intellij.ier.common.EvalRecord;
import io.zhile.research.intellij.ier.common.Resetter;
import io.zhile.research.intellij.ier.helper.AppHelper;
import io.zhile.research.intellij.ier.helper.PluginHelper;
import io.zhile.research.intellij.ier.helper.ResetTimeHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class MainForm {
    private JPanel rootPanel;
    private JButton btnReset;
    private JList<String> lstMain;
    private JLabel lblLastResetTime;
    private JButton btnReload;
    private JLabel lblFound;
    private JLabel lblLastResetTimeLabel;
    private JCheckBox chkResetAuto;
    private JLabel lblVersion;
    private JCheckBox chkAutoLogout;
    private DialogWrapper dialogWrapper;
    private DefaultListModel<String> listModel;

    public MainForm(Disposable disposable) {
        this(disposable, null);
    }

    public MainForm(Disposable disposable, DialogWrapper wrapper) {
        this.$$$setupUI$$$();
        this.listModel = new DefaultListModel();
        this.dialogWrapper = wrapper;
        Disposer.register((Disposable)disposable, (Disposable)new Disposable(){

            public void dispose() {
                MainForm.this.rootPanel.removeAll();
                MainForm.this.listModel = null;
                MainForm.this.dialogWrapper = null;
            }
        });
    }

    private static void boldFont(Component component) {
        Font font = component.getFont();
        component.setFont(font.deriveFont(font.getStyle() | 1));
    }

    private static void addActionEventListener(final AbstractButton button, final ActionListener listener, Disposable disposable) {
        button.addActionListener(listener);
        Disposer.register((Disposable)disposable, (Disposable)new Disposable(){

            public void dispose() {
                button.removeActionListener(listener);
            }
        });
    }

    public JPanel getContent(Disposable disposable) {
        Disposer.register((Disposable)disposable, (Disposable)new Disposable(){

            public void dispose() {
                MainForm.this.rootPanel.removeAll();
            }
        });
        MainForm.boldFont(this.lblFound);
        MainForm.boldFont(this.lblLastResetTimeLabel);
        this.reloadLastResetTime();
        this.lblVersion.setText("v" + PluginHelper.getPluginVersion());
        this.chkAutoLogout.setSelected(Resetter.isAutoLogout());
        MainForm.addActionEventListener(this.chkAutoLogout, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Resetter.setAutoLogout(MainForm.this.chkAutoLogout.isSelected());
            }
        }, disposable);
        this.chkResetAuto.setSelected(Resetter.isAutoReset());
        MainForm.addActionEventListener(this.chkResetAuto, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Resetter.setAutoReset(MainForm.this.chkResetAuto.isSelected());
            }
        }, disposable);
        this.lstMain.setModel(this.listModel);
        this.reloadRecordItems();
        this.btnReload.setIcon(AllIcons.Actions.Refresh);
        MainForm.addActionEventListener(this.btnReload, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainForm.this.reloadLastResetTime();
                MainForm.this.reloadRecordItems();
            }
        }, disposable);
        this.btnReset.setIcon(AllIcons.General.Reset);
        MainForm.addActionEventListener(this.btnReset, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainForm.this.resetEvalItems();
            }
        }, disposable);
        if (null != this.dialogWrapper) {
            this.dialogWrapper.getRootPane().setDefaultButton(this.btnReset);
            this.rootPanel.setMinimumSize(new Dimension(640, 260));
        }
        return this.rootPanel;
    }

    private void reloadLastResetTime() {
        this.lblLastResetTime.setText(ResetTimeHelper.getLastResetTimeStr());
    }

    private void reloadRecordItems() {
        this.listModel.clear();
        Resetter.touchLicenses();
        List<EvalRecord> recordItemList = Resetter.getEvalRecords();
        for (EvalRecord record : recordItemList) {
            this.listModel.addElement(record.toString());
        }
    }

    private void resetEvalItems() {
        if (0 != Messages.showYesNoDialog((String)"Your IDE will restart after reset!\nAre your sure to reset?", (String)PluginHelper.getPluginName(), (Icon)AllIcons.General.Reset)) {
            return;
        }
        Resetter.touchLicenses();
        Resetter.reset(Resetter.getEvalRecords());
        ResetTimeHelper.resetLastResetTime();
        this.listModel.clear();
        if (null != this.dialogWrapper) {
            this.dialogWrapper.close(0);
        }
        AppHelper.restart();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JButton jButton;
        JButton jButton2;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JLabel jLabel2;
        JLabel jLabel3;
        JLabel jLabel4;
        JPanel jPanel;
        this.rootPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0, 5, 5));
        jPanel.add((Component)jPanel2, "North");
        this.lblLastResetTimeLabel = jLabel4 = new JLabel();
        jLabel4.setText("Last Reset Time\uff1a");
        Component component = jPanel2.add(jLabel4);
        this.lblLastResetTime = jLabel3 = new JLabel();
        jLabel3.setText("");
        Component component2 = jPanel2.add(jLabel3);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel.add((Component)jPanel3, "Center");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(0, 5, 5));
        jPanel3.add((Component)jPanel4, "North");
        this.lblFound = jLabel2 = new JLabel();
        jLabel2.setText("Found\uff1a");
        Component component3 = jPanel4.add(jLabel2);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(5, 5, 5, 5), -1, -1, false, false));
        jPanel3.add((Component)jPanel5, "Center");
        JScrollPane jScrollPane = new JScrollPane();
        jPanel5.add((Component)jScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        JList jList = new JList();
        this.lstMain = jList;
        jList.setSelectionMode(0);
        jScrollPane.setViewportView(jList);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout(0, 0));
        jPanel.add((Component)jPanel6, "South");
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new FlowLayout(2, 5, 5));
        jPanel6.add((Component)jPanel7, "Center");
        this.chkAutoLogout = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Logout when reset");
        jCheckBox2.setToolTipText("Logout account when reset(Global)");
        Component component4 = jPanel7.add(jCheckBox2);
        this.chkResetAuto = jCheckBox = new JCheckBox();
        jCheckBox.setText("Auto reset before per restart");
        jCheckBox.setToolTipText("Auto reset before per restart(For this IDE)");
        Component component5 = jPanel7.add(jCheckBox);
        this.btnReload = jButton2 = new JButton();
        jButton2.setText("Reload");
        jButton2.setToolTipText("Reload eval records list");
        Component component6 = jPanel7.add(jButton2);
        this.btnReset = jButton = new JButton();
        jButton.setText("Reset");
        jButton.setToolTipText("Reset eval info and restart IDE");
        Component component7 = jPanel7.add(jButton);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BorderLayout(0, 0));
        jPanel6.add((Component)jPanel8, "West");
        jPanel8.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5), null, 0, 0, null, null));
        this.lblVersion = jLabel = new JLabel();
        ((Component)jLabel).setEnabled(false);
        jLabel.setText("v1.0.0");
        jPanel8.add((Component)jLabel, "Center");
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.rootPanel;
    }
}

